#pragma once

#define VM_API __declspec(dllexport)

#define MAX_INSTRUCTIONS 128			//maximlani pocet instrukci na jedno volani obsluzne funcke

struct ScriptDependencies;

//***********************************************************************************************************************
//Rozhrani pro praci s virtualnim strojem
//***********************************************************************************************************************
__interface IVirtualMachine
{
public:
	void						Init(ScriptDependencies* scriptdependencies) = 0;
	void						Run(CFunctionInstance*	function,int iMaxInstructions) = 0;
	HRESULT						AddRef() = 0;
	HRESULT						Release() = 0;

};
//***********************************************************************************************************************
//rozhrani pro praci se skriptem
//***********************************************************************************************************************
__interface VM_API IScript
{
public:
	HRESULT						LoadScript(const char* file) = 0;
    void						HandleScripts(int iMaxInstructions = MAX_INSTRUCTIONS,bool* isnext = NULL) = 0;
	HRESULT						StartMain() = 0;
	void						Stop() = 0;
	HRESULT						RunFunction(char* function) = 0;

	unsigned int				GetCodeSegmentSize() = 0;
	unsigned char*				GetCodeSegment() = 0;
	unsigned int				GetNumConstants() = 0;
	CStack<StackItem>*			GetConstantTable() = 0;
	CList<FUNCTION_HEADER*>*	GetFunctionsList() = 0;
	CFunctionInstance*			GetCurrFunction() = 0;


	HRESULT						AddRef() = 0;
	HRESULT						Release() = 0;
};

